<?php
$url = "https://api.github.com"; // Public API to test

$ch = curl_init();

// Basic cURL setup
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

// GitHub requires a user-agent header
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "User-Agent: PHP-cURL-Test"
]);

$response = curl_exec($ch);

// Check for errors
if (curl_errno($ch)) {
    echo "❌ cURL Error: " . curl_error($ch);
} else {
    echo "✅ cURL executed successfully:\n\n";
    echo htmlspecialchars($response);
}

curl_close($ch);
?>
